#!/bin/sh

MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_MSG=""
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_OK=0
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_ERROR=1

MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_CODE=${MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_ERROR}
MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_ROLLING=0

master_page_switch_to_cluster_mode() {
	debug_print "in function '${FUNCNAME[0]}'"
	####################################################################
	# roy_chuang 20120911
	# no matter it occur error or not, it always return to main page, 
	# so don't need to change the result code and rolling value
	####################################################################
	MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_CODE=$MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_OK
	MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_ROLLING=-1
	
	local msg
	local ret
	msg=`dtascfg "${DTASCFG_XML_FILE}" get cli master_switchable`
	ret="${?}"
	debug_print "ret='${ret}', msg='${msg}'"
	if [ "${ret}" -eq 0 -a "${msg}" -eq 1 ]; then
		tp_yesno \
			"${MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_TITLE}" \
			"${MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_TEXT}"
		
	elif [ "${ret}" -ne 0 ]; then
		tp_msg_ok \
			"${MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_TITLE}" \
			"${msg}" \
			"${STRING_OK}"
		return
		
	else
		warning "${MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_NOTIFY}"
		return
	fi
	
	if [ "${TP_YESNO_RESULT_SELECT}" != "${TP_YESNO_RESULT_YES}" ]; then
	#	MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_CODE=$MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_OK
	#	MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_ROLLING=-1
		return
	fi
	
	utility_switch_to_cluster_mode
	if [ "${?}" -ne 0 ]; then
		warning "${MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_ERROR}"
		#MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_CODE=$MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_OK
		#MASTER_PAGE_SWITCH_TO_CLUSTER_MODE_RESULT_ROLLING=-1
		return
	fi
	
	sh ./notify_configuration_change.sh
	RT_MASTER_MODE="0"
}